//--------------------------------------------------------------------------
//
//  Software for MSP430 based e-meters.
//
//  THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
//  REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
//  INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
//  FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
//  COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
//  TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
//  POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
//  INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
//  YOUR USE OF THE PROGRAM.
//
//  IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
//  CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
//  THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
//  OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
//  OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
//  EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
//  REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
//  OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
//  USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
//  AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
//  YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
//  (U.S.$500).
//
//  Unless otherwise stated, the Program written and copyrighted
//  by Texas Instruments is distributed as "freeware".  You may,
//  only under TI's copyright in the Program, use and modify the
//  Program without any charge or restriction.  You may
//  distribute to third parties, provided that you transfer a
//  copy of this license to the third party and the third party
//  agrees to these terms by its first use of the Program. You
//  must reproduce the copyright notice and any other legend of
//  ownership on each copy or partial copy, of the Program.
//
//  You acknowledge and agree that the Program contains
//  copyrighted material, trade secrets and other TI proprietary
//  information and is protected by copyright laws,
//  international copyright treaties, and trade secret laws, as
//  well as other intellectual property laws.  To protect TI's
//  rights in the Program, you agree not to decompile, reverse
//  engineer, disassemble or otherwise translate any object code
//  versions of the Program to a human-readable form.  You agree
//  that in no event will you alter, remove or destroy any
//  copyright notice included in the Program.  TI reserves all
//  rights not specifically granted under this license. Except
//  as specifically provided herein, nothing in this agreement
//  shall be construed as conferring by implication, estoppel,
//  or otherwise, upon you, any license or other right under any
//  TI patents, copyrights or trade secrets.
//
//  You may not use the Program in non-TI devices.
//
//  File: emeter-background.c
//
//  Steve Underwood <steve-underwood@ti.com>
//  Texas Instruments Hong Kong Ltd.
//
//  $Id: emeter-background.c,v 1.39 2008/10/28 10:13:40 a0754793 Exp $
//
/*! \file emeter-structs.h */
//
//--------------------------------------------------------------------------
//
//  MSP430 background (interrupt) routines for e-meters
//
//  This software is appropriate for single phase and three phase e-meters
//  using a voltage sensor plus a CT or shunt resistor current sensors, or
//  a combination of a CT plus a shunt.
//
//    The background process deals with the input samples.
//    These are first stored into buffers.
//    The buffered samples are processed as follows:
//    -Voltage and current signals are converted to DC-less AC signals
//    -The current signal is phase compensated
//    -Voltage and current are signed multiplied to give power.
//    -Power samples are accumulated. The accumulated power samples are averaged (in foreground.c)
//     after a number of voltage cycles has been detected.
//
#include "..\display\foreground.h"
#include <stdint.h>
#include <stdlib.h>
#include "..\display\Menu.h"
#include "io.h"

#include <emeter-toolkit.h>
#include "emeter-structs.h"
#include "..\display\main.h"

#include "..\display\Menu.h"
#include "..\display\LCD.h"
#if !defined(NULL)
#define NULL    (void *) 0
#endif

#ifdef REALTIME_PULSE 
int16_t activepower_accum[3] = {0,0,0};
long act_power_high = 0;
#endif
//static void __inline__ close_peripheral(void)
//{
//    P1DIR &=~ BIT2;     // open the pluse out
//    SD24CTL = 0;        // unable sd
//}

static void __inline__ log_parameters(void)   //ÿ4096жϺһΡ
{

#define i 0

    /* Take a snapshot of various values for logging purposes; tell the
       foreground to deal with them; and clear the working values ready
       for the next analysis period. */// жѹǷ
    if (phase->V_endstops <= 0)     //  V_endstops ʼֵΪ2020ιغжϸôβʵЧ
        phase->status |= V_OVERRANGE;           // ñ־λ
    else
        phase->status &= ~V_OVERRANGE;
    phase->V_endstops = ENDSTOP_HITS_FOR_OVERLOAD;                 // ֵظֵ

    transfer48(phase->V_sq_accum_logged, phase->V_sq_accum);       // Чѹֵֵ̬

    if (phase->current[0].I_endstops <= 0)                         // жͨ1Ƿ
        phase->status |= I_OVERRANGE;            // ñ־λ
    else
        phase->status &= ~I_OVERRANGE;
    phase->current[0].I_endstops = ENDSTOP_HITS_FOR_OVERLOAD;
#if defined(NEUTRAL_MONITOR_SUPPORT)      
    if (phase->current[1].I_endstops <= 0)                         // жͨ2Ƿ        
        phase->status |= I_NEUTRAL_OVERRANGE;    // ñ־λ
    else
        phase->status &= ~I_NEUTRAL_OVERRANGE;
    phase->current[1].I_endstops = ENDSTOP_HITS_FOR_OVERLOAD;      
#endif
    // Чйʡ޹ֵ0
    {
        transfer48(phase->current[0].I_sq_accum_logged[i], phase->current[0].I_sq_accum[i]);

        transfer48(phase->current[0].P_accum_logged[i], phase->current[0].P_accum[i]);
        transfer48(phase->current[0].P_reactive_accum_logged[i], phase->current[0].P_reactive_accum[i]);

#if defined(NEUTRAL_MONITOR_SUPPORT)
        transfer48(phase->current[1].I_sq_accum_logged[i], phase->current[1].I_sq_accum[i]);

        transfer48(phase->current[1].P_accum_logged[i], phase->current[1].P_accum[i]);
        transfer48(phase->current[1].P_reactive_accum_logged[i], phase->current[1].P_reactive_accum[i]);
#endif
    }
    phase->sample_count_logged = phase->sample_count;
    phase->sample_count = 0;
    
    /* Tell the foreground there are things to process. */
    phase->status |= NEW_LOG;   // ЧѹЧйʡ޹ʶȡ
#ifdef DCFILTER_USED            // ʹDC˲˲ʱֵ...logged
    phase->V_accum_logged = phase->V_accum ;
    phase->I_accum_logged[0] = phase->I_accum[0];
    phase->I_accum_logged[1] = phase->I_accum[1];    
    phase->V_accum = 0;
    phase->I_accum[0] = 0;
    phase->I_accum[1] = 0;  
#endif

#undef i

}

int16_t adc_buffer[3];
/*---------------------------------------------------------------------------
  This is the main interrupt routine where the main signal processing is done
  ---------------------------------------------------------------------------*/
ISR(SD24, adc_interrupt)
{
    int16_t V_sample;                        //   ѹֵ
    int16_t corrected;                       //   ̬
    int16_t I_live_sample;                   //   ߲
    unsigned long consumed_energy;
#if defined(NEUTRAL_MONITOR_SUPPORT)         //   Ŀֻߵߵ
    int16_t I_neutral_sample;                //   ߲
#endif

#define i 0
#define use_stage 0

    int adc_ptr;

#if defined(MAINS_FREQUENCY_SUPPORT)          //   ΪƵ׼
    int k;
    int x;
    int y;
    int z;
#endif
    if(SVSCTL&SVSFG)       // get total_consumed_energy
    {
        P1OUT |= BIT2;
        P1DIR &=~ (BIT2+BIT5);     // unable  led and backlight
        P1SEL &=~ (BIT2+BIT5);
        /*
        IOô
        P1DIR  P1DIRP1SEL P1SEL2
        2011 0506 1836
        */
        SD24CCTL_KEY &= ~SD24SC;
        SD24CCTL_VOLTAGE &= ~SD24SC;
        SD24CCTL_LIVE &= ~SD24SC;
        SD24INCTL_VOLTAGE = 0;
        SD24CCTL_VOLTAGE = 0;
        SD24PRE_VOLTAGE = 0;
        SD24INCTL_LIVE = 0;
        SD24CCTL_LIVE = 0;
        SD24PRE_LIVE = 0;
        SD24INCTL_KEY = 0;
        SD24CCTL_KEY = 0;
        SD24PRE_KEY = 0;
        SD24CTL = 0;
       
        menustatu.poweroff_fg = 1;
        menustatu.enter_lpm = 1;
        
        consumed_energy = phase->energy.total_consumed_energy;
        consumed_energy += *(long*)P_ENERGY_ADD;           // read total_comsumed_energy  
        if(consumed_energy>=15999999)                      // 10000 * 1600
        {
            consumed_energy = consumed_energy%15999999;
        }
        flash_clr((int *)P_ENERGY_ADD);    // ʷ洢
        flash_write_int32((long *)P_ENERGY_ADD, consumed_energy);    //write total_consumed_energy 
        FCTL1 = FWKEY;                      /* Erase, write = 0 */
        FCTL3 = FWKEY | LOCK;
        SVSCTL &=~ SVSFG;
        phase->energy.total_consumed_energy = 0;
        kbStatus = 0;          //л ʱʾ
        rtc_state = RTC_TYPE1;
        AnalysisRTC(rtc_state);
    }
    // Get key value
    GetKey();                                 //   жϰ
    SD24CCTL_KEY &= ~SD24IFG;                 //   ־λ
    
    if (!(SD24CCTL_VOLTAGE & SD24IFG))           // жϵǰ·ͨѹ ߵ/ߵ
    {                                            
        /* We do not have a complete set of samples yet, but we may need to pick
           up some current values at this time */
        /*ûȫһ̣ɴӴжжǰֵ*/
    #if defined(NEUTRAL_MONITOR_SUPPORT)         // ǰõǲֵʽ
        if ((SD24CCTL_NEUTRAL & SD24IFG))        // 
        {
            adc_buffer[2] = SD24MEM_NEUTRAL;
            SD24CCTL_NEUTRAL &= ~SD24IFG;
        }
    #endif
        if ((SD24CCTL_LIVE & SD24IFG))           // 
        {
            adc_buffer[1] = SD24MEM_LIVE;
            SD24CCTL_LIVE &= ~SD24IFG;
        }
        return;
    }
    // λ ô....FIR table ...
    // IIR˲ʽ
    /* Filter away the DC bias.
       СλƫʱЧ
       Do the phase lag compensation. Use a simple FIR approach,
       and absorb the non-unity gain of the filter in the overall
       current/power scaling later on. This is OK for the small
       phase shifts we expect to get. It would cause dynamic
       range problems for larger shifts. Note the some of this
       phase shift is due to the operation of the ADC itself. It
       performs sequential conversions of its 8 inputs, so there is
       some time delay between sampling of the various sensors.
    
       Accumulate power for each of the channels. These will
       be divided by the number of samples at the end of the
       measurement cycles, resulting in an average power
       value for each source.

       If RMS voltage and/or current readings are required, calculate the
       dot products needed to evaluate these. */

    /* Voltage is available */
    // ôж˴SDǵѹͨģǣô˴βֵǷЧ
    adc_buffer[0] = SD24MEM_VOLTAGE;    // ȡѹ
    SD24CCTL_VOLTAGE &= ~SD24IFG;
    /* Pick up any current samples which may have occurred a little before the
       voltage sample, but not those which may have occurred just after the
       voltage sample. */
    // ѹ֮ǰĵΪЧֵѹ֮ĵѹΪЧֵΪʲôһһӦʲô
        #if defined(NEUTRAL_MONITOR_SUPPORT)  // ȡ߲
    if ((unsigned char)(phase->current[1].in_phase_correction[0].sd16_preloaded_offset & 0xFF) < 128  &&  (SD24CCTL_NEUTRAL & SD24IFG))
    {
        adc_buffer[2] = SD24MEM_NEUTRAL;
        SD24CCTL_NEUTRAL &= ~SD24IFG;
    }
        #endif
    if ((unsigned char)(phase->current[0].in_phase_correction[0].sd16_preloaded_offset & 0xFF) < 128  &&  (SD24CCTL_LIVE & SD24IFG))
    {
        adc_buffer[1] = SD24MEM_LIVE;
        SD24CCTL_LIVE &= ~SD24IFG;
    }
    /* We have a complete set of samples. Process them. */
    adc_ptr = -1;  // ־λ

    //set sample ready interrupt if respond IE is set
    //this interrupt is not valid on current version because there is no fast enouth
    //serial port to send them out
    //if( phase->int_enable & CSGWFSRDYFG )
    //  set_int_flag(CSGWFSRDYFG);//notify new emeter parameters ready               
    
////////////////////////////////////////////////////////////////////////////////
//////////////////////Now we already got samples, start caculating/////////////
///////////////////////////////////////////////////////////////////////////////  
    //set_total_reactive_energy_pulse_indicator();    //test mips
    //kick_watchdog();
    //first of all we chech if it's time to logging        // ѹֵѻȡϣadc_bufferУŽݴ
    if(meter_status&TIMETOLOG){    //4096ΣTIMETOLOG λ
      meter_status &= ~TIMETOLOG;  // ۼӲ
      log_parameters();    
    }
    
    {//ÿж϶ִ
////////////////////////////////////////////////////////////////////////////////
//////////////////////////Filtering V sample and accumulate V*V/////////////////      
        V_sample = adc_buffer[++adc_ptr];   //  buf[0] ѹ     buf[1]ߵ   buf[2]ߵ
        if ((V_sample >= ADC_MAX  ||  V_sample <= ADC_MIN)  &&  phase->V_endstops)
            phase->V_endstops--;   // phase->V_endstops ֵ 20ֵһ 
        
        if((gCsgconf&CSGCON_IDFILTERTYPE)==0) //IIR filter used  //ֱ˲
          V_sample = dc_filter(&phase->V_dc_estimate, V_sample);
        else{                                                   //or average apppoach used
          phase->V_accum += V_sample;     // ˲ʽ IIR  ȡֵCSGCON_IDFILTERTYPEǷ
          V_sample -= phase->V_dc_estimate>>DCFILTER_SHIFT;
        }           
        // mul  multiplication  ˷
        accum48(phase->V_sq_accum, imul16(V_sample, V_sample));// ǰѹֵƽۼӵV_sq_accumȵ1sʱٽV_sq_accumV_sq_accum_logged
        // λУôҪʷֵ ݴСΪ 32 words
        /* We need to save the history of the voltage signal if we are performing phase correction, and/or
           measuring the quadrature shifted power (to obtain an accurate measure of one form of the reactive power). */
        // buf32ѹֵ
        phase->V_history[(int) phase->V_history_index] = V_sample;
        // ݷʽ  SDѹbufֵ --> adc_buffer[0] --> V_sample--dc˲--> V_sample -->phase->V_history/V_sq_accum  
////////////////////////////////////////////////////////////////////////////////
/////////////////////////Filtering I sample and accumulate I*I//////////////////  
        //IRMS caculation need filtered samples to remove DC offset. 
        // ǻߵĲ֪ʷֵãλ
        corrected = adc_buffer[++adc_ptr];// ȡ߲
        if((gCsgconf&CSGCON_IDFILTERTYPE)==0) //IIR filter used
            // Ϊȡʷֵѹȡǰֵ phase->current[0].I_history[0][0], 
            // ⣬phase->current[0].history[0][0]Ǻʱֵģǰֵ㣿
          I_live_sample = dc_filter(&phase->current[0].I_dc_estimate[0], phase->current[0].I_history[0][0]);         
        else{        
          phase->I_accum[0] += corrected;
          I_live_sample = phase->current[0].I_history[0][0]- (phase->current[0].I_dc_estimate[0]>>DCFILTER_SHIFT);
        }
        
        if ((corrected >= ADC_MAX  ||  corrected <= ADC_MIN)  &&  phase->current[0].I_endstops)
            phase->current[0].I_endstops--;// ж߲Ƿ
        // ˴ I_HISTORY_STEPS ֵΪ2
        phase->current[0].I_history[0][0] = phase->current[0].I_history[0][1];
#if I_HISTORY_STEPS > 2
        phase->current[0].I_history[0][1] = phase->current[0].I_history[0][2];
#endif
#if I_HISTORY_STEPS > 3
        phase->current[0].I_history[0][2] = phase->current[0].I_history[0][3];
#endif
#if I_HISTORY_STEPS > 4
        phase->current[0].I_history[0][3] = phase->current[0].I_history[0][4];
#endif
        // ǰֵ߲currentI_history[0][1]I_history[0][1]I_history[0][0]
        // ˵IIR dc˲ĵֵΪǰֵǰǰֵ֪ΪҪ
        phase->current[0].I_history[0][I_HISTORY_STEPS - 1] = corrected;
        // SDֵ-->adc_buffer[1]--> I_history[0][1] --> I_history[0][0]
        // I_history[0][0] --> dc˲ I_live_sample --> I_sq_accum
        accum48(phase->current[0].I_sq_accum[use_stage], imul16(I_live_sample, I_live_sample));
////////////////////////////////////////////////////////////////////////////////
///////////////////////////////accumulate P and Q//////////////////              
        // ǻ߲... 
            /* Perform phase shift compensation, to allow for the time
               between ADC samplings, internal phase shifts in CTs, etc.
               This uses a 1 tap FIR (basically an interpolator/extrapolator) */
        //But power accumulation can not use DC filter because it may induce jittering
        if((gCsgconf&CSGCON_IDCREMOVEEN)==0)    //no dc remove on I   
          I_live_sample = phase->current[0].I_history[0][0];  // ȡβǰǰֵ
        // ȡʷѹֵ
        corrected = phase->V_history[(phase->V_history_index - phase->current[0].in_phase_correction[use_stage].step+1) & V_HISTORY_MASK];  
        // V*IֵۼӵP_accum  й
        accum48(phase->current[0].P_accum[use_stage], imul16(corrected, I_live_sample));
#ifdef REALTIME_PULSE            
        accum48(activepower_accum, imul16(corrected, I_live_sample));
#endif  
        if((gCsgconf&CSGCON_QOFF)==0){//reactive power function not off
          corrected = (Q1_15_mul(phase->V_history[(phase->V_history_index - phase->current[0].quadrature_correction[use_stage].step - 1) & V_HISTORY_MASK], phase->current[0].quadrature_correction[use_stage].fir_beta) >> 1)
                      + (phase->V_history[(phase->V_history_index - phase->current[0].quadrature_correction[use_stage].step) & V_HISTORY_MASK] >> 1);
          accum48(phase->current[0].P_reactive_accum[use_stage], imul16(corrected, I_live_sample));
        }
////////////////////////////////////////////////////////////////////////////////
///////////////////////////////accumulate II VV P Q for neutral///////////////// 
#if defined(NEUTRAL_MONITOR_SUPPORT)
        corrected = adc_buffer[++adc_ptr];
        if((gCsgconf&CSGCON_IDFILTERTYPE)==0) //IIR filter used  
          I_neutral_sample = dc_filter(&phase->current[1].I_dc_estimate[0], phase->current[1].I_history[0][0]);         
        else{  
          phase->I_accum[1] += corrected;
          I_neutral_sample = phase->current[1].I_history[0][0]-phase->current[1].I_dc_estimate[0]>>DCFILTER_SHIFT;
        }

        if ((corrected >= ADC_MAX  ||  corrected <= ADC_MIN)  &&  phase->current[1].I_endstops)
            phase->current[1].I_endstops--;
        phase->current[1].I_history[0][0] = phase->current[1].I_history[0][1];
  #if I_HISTORY_STEPS > 2
        phase->neutral.I_history[0][1] = phase->neutral.I_history[0][2];
  #endif
  #if I_HISTORY_STEPS > 3
        phase->neutral.I_history[0][2] = phase->neutral.I_history[0][3];
  #endif
  #if I_HISTORY_STEPS > 4
        phase->neutral.I_history[0][3] = phase->neutral.I_history[0][4];
  #endif
        phase->current[1].I_history[0][I_HISTORY_STEPS - 1] = corrected;
        accum48(phase->current[1].I_sq_accum[0], imul16(I_neutral_sample, I_neutral_sample));

        if((gCsgconf&CSGCON_IDCREMOVEEN)==0)    //no dc remove on I        
          I_neutral_sample = phase->current[1].I_history[0][0];
          
        corrected = phase->V_history[(phase->V_history_index - phase->current[1].in_phase_correction[use_stage].step) & V_HISTORY_MASK];
        accum48(phase->current[1].P_accum[0], imul16(corrected, I_neutral_sample));
        
        if((gCsgconf&CSGCON_QOFF)==0){//reactive power function not off
          corrected = (Q1_15_mul(phase->V_history[(phase->V_history_index - phase->current[1].quadrature_correction[use_stage].step - 1) & V_HISTORY_MASK], phase->current[1].quadrature_correction[use_stage].fir_beta) >> 1)
                      + (phase->V_history[(phase->V_history_index - phase->current[1].quadrature_correction[use_stage].step) & V_HISTORY_MASK] >> 1);
          accum48(phase->current[1].P_reactive_accum[0], imul16(corrected, I_neutral_sample));
        }
#endif
////////////////////////////////////////////////////////////////////////////////
///////////////////////////////update sample count/////////////////         
        phase->V_history_index = (phase->V_history_index + 1) & V_HISTORY_MASK;
        ++phase->sample_count;    // BufСΪ32ֽڣҪѳλȫʡȥ
        // Ϻָʾ1
////////////////////////////////////////////////////////////////////////////////
///////////////Frequency and power factor caculation on live///////////////////
//There is a filtering algorithm on frequency caculation to remove sparkle////
        // Ƶʱ˲㷨
        /* Do the power cycle start detection */
        /* There is no hysteresis used here, but since the signal is
           changing rapidly at the zero crossings, and is always of
           large amplitude, miscounting cycles due to general noise
           should not occur. Spikes are another matter. A large spike
           could cause the power cycles to be miscounted, but does not
           matter very much. The cycle counting is not critical to power
           or energy measurement. */
#if defined(MAINS_FREQUENCY_SUPPORT)        
        phase->cycle_sample_count += 256;
#endif
        if (abs(V_sample - phase->last_V_sample) <= phase->since_last*MAX_PER_SAMPLE_VOLTAGE_SLEW)
        {// жǷⲿţÿνж϶ִд˲
            /* This doesn't look like a spike - do mains cycle detection, and
               estimate the precise mains period */
            if (V_sample < 0)
            {//˴Ϊ˷֧˴Ϊelse
                /* Log the sign of the signal */
                phase->status &= ~V_POS;
            }
            else
            {
                if (!(phase->status & V_POS))
                {// ǰβֵΪ˴Ϊ˷֧  ǰδ˴ξΪelse                       
#if defined(MAINS_FREQUENCY_SUPPORT)
                    /* Apply limits to the sample count, to avoid spikes or dying power lines disturbing the
                       frequency reading too much */
                    /* The mains should be <40Hz or >70Hz to fail this test! */
                    if (256*SAMPLES_PER_10_SECONDS/700 <= phase->cycle_sample_count  &&  phase->cycle_sample_count <= 256*SAMPLES_PER_10_SECONDS/400)
                    {
                        /* A mains frequency measurement procedure based on interpolating zero crossings,
                           to get a fast update rate for step changes in the mains frequency */
                        /* Interpolate the zero crossing by successive approx. */
                        z = V_sample - phase->last_V_sample;
                        x = 0;
                        y = 0;
                        for (k = 0;  k < 8;  k++)
                        {
                            y <<= 1;
                            z >>= 1;    
                            x += z;
                            if (x > V_sample)
                                x -= z;
                            else
                                y |= 1;
                        }
                        /* Now we need to allow for skipped samples, due to spike detection */
                        z = y;
                        while (phase->since_last > 1)
                        {
                            z += y;
                            phase->since_last--;
                        }
                        /* z is now the fraction of a sample interval between the zero
                           crossing and the current sample, in units of 1/256 of a sample */
                        /* A lightly damped filter should now be enough to remove noise and get a
                           stable value for the frequency */
                        phase->mains_period += ((int32_t) (phase->cycle_sample_count - z) << 12) - (phase->mains_period >> 4);
                        /* Start the next cycle  with the residual fraction of a sample */
                        phase->cycle_sample_count = z;
                    }
                    else
                    {
                        phase->cycle_sample_count = 0;
                    }
#endif                
#if defined(POWER_FACTOR_SUPPORT)
                    /* Determine whether the current leads or lags, in a noise tolerant manner.
                       Testing 50 cycles means we will respond in about one second to a genuine
                       swap between lead and lag. Since that is also about the length of our
                       measurement blocks, this seems a sensible response time. */
                    if (I_live_sample < V_sample)
                    {
                        if (phase->current[0].leading > -50)
                            phase->current[0].leading--;
                    }
                    else
                    {
                        if (phase->current[0].leading < 50)
                            phase->current[0].leading++;
                    }
    #if defined(NEUTRAL_MONITOR_SUPPORT)
                    if (I_neutral_sample < V_sample)
                    {
                        if (phase->current[1].leading > -50)
                            phase->current[1].leading--;
                    }
                    else
                    {
                        if (phase->current[1].leading < 50)
                            phase->current[1].leading++;
                    }
    #endif
#endif
                    /* See if a sufficiently long measurement interval has been
                       recorded, and catch the start of the next cycle. We do not
                       really care how many cycles there are, as long as the block
                       is a reasonable length. Setting a minimum of 1 second is
                       better than counting cycles, as it is not affected by noise
                       spikes. Synchronising to a whole number of cycles reduces
                       block to block jitter, though it doesn't affect the long
                       term accuracy of the measurements. */
                    if (phase->sample_count >= SAMPLES_PER_SECONDS)//4096ΣTIMETOLOG λ
                    {
                      meter_status |= TIMETOLOG;
                      //Here we do not log parameter because cycle counting have already take too much mips
                      //leave logging to next sample 
                      //log_parameters();
                    }
                    
                    //set leading edge cross zero event interrupt if respond IE is set
                    if( phase->int_enable & CSGZXLDFG )
                      set_int_flag(CSGZXLDFG);//notify zero cross event                
                }
                /* Log the sign of the signal */
                phase->status |= V_POS;
            }
            phase->since_last = 0;
            phase->last_V_sample = V_sample;
        }// if (abs(V_sample - phase->last_V_sample) <= phase->since_last*MAX_PER_SAMPLE_VOLTAGE_SLEW)
        phase->since_last++;

        if (phase->sample_count >= SAMPLES_PER_SECONDS + 200)
        {                              
          /* We don't seem to be detecting the end of a mains cycle, so force
               the end of processing block condition. */
          //Make sure no cycle counting happened before in this sample         
            if(!(meter_status&TIMETOLOG))
              log_parameters();
        }
        
////////////////////////////////////////////////////////////////////////////////  
        if (I_live_sample < 0)
        {
            /* Log the sign of the signal */
            phase->status &= ~I_POS;
        }
        else
        {
            phase->status |= I_POS;
        }
////////////////////////////////////////////////////////////////////////////////       
#if defined(NEUTRAL_MONITOR_SUPPORT)
        if (I_neutral_sample < 0)
        {
            /* Log the sign of the signal */
            phase->status &= ~I_NEUTRAL_POS;
        }
        else
        {
            /* Log the sign of the signal */
            phase->status |= I_NEUTRAL_POS;
        }
#endif
    }
    
////////////////////////////////////////////////////////////////////////////////
///////////////////////////////Generate energy pulse///////////////// 
    /* We now play the last measurement interval's power level, evaluated
       in the foreground, through this measurement interval. In this way
       we can evenly pace the pulsing of the LED. The only error produced
       by this is the ambiguity in the number of samples per measurement.
       This should not exceed 1 or 2 in over 4000. */
    int32_t xx;
    if ((phase->status & CURRENT_FROM_NEUTRAL))
      xx = phase->active_power[1];
    else
      xx = phase->active_power[0];  
    //accumulate all power, no matter positive or negtive, but here we change negtive power to positive to facillate pulse generation. 
    //This will not affect the sign of power stored.
    if((gCsgconf&CSGCON_EMOD_MASK)==CSGCON_EMOD2){  //0804 accumulate absolute power
      if(xx < 0)
        xx = -xx;
    }
    else{
      if((gCsgconf&CSGCON_EMOD_MASK)==CSGCON_EMOD1){//accumulate no negtive power
        if(xx < 0)
          xx = 0;
      }
      else
        xx = xx;
    }
    
    if(xx>0){
      phase->energy.total_active_power_counter += xx;
#ifndef REALTIME_PULSE           
      if (phase->energy.total_active_power_counter >= gCurrent_threshold)
      {  
        phase->energy.total_active_power_counter -= gCurrent_threshold;
#else
      if ((act_power_high = (unsigned long)activepower_accum[1] + ((long)activepower_accum[2] << 16)) >= gCurrent_threshold)
      {
        act_power_high -= gCurrent_threshold;
        activepower_accum[1] = act_power_high&0x00ff;
        activepower_accum[2] = act_power_high>>16;
#endif
               
        if ((gPower_const <= 1000)&&(++phase->energy.extra_total_active_power_counter < 16)){
          ;//in extra power counter mode, and not accumulate enough power, skipped                 
        }
        else{
            phase->energy.extra_total_active_power_counter = 0;
            ++phase->energy.total_consumed_energy;
            if (phase->energy.total_consumed_energy == 0){
              phase->status |= ENERGY_LOGABLE;
              //set P energy overflow event interrupt if respond IE is set
              if(phase->int_enable & CSGPEOFG)
                set_int_flag(CSGPEOFG);//notify active energy overflow event               
            }
                  /* Pulse the LED. Long pulses may not be reliable, as at full
                     power we may be pulsing many times per second. People may
                     check the meter's calibration with an instrument that counts
                     the pulsing rate, so it is important the pulses are clear,
                     distinct, and exactly at the rate of one per
                     1/ENERGY_PULSES_PER_KW_HOUR kW/h. */  
            if(gCsgconf&CSGCON_PPEN_MASK){
              set_total_energy_pulse_indicator(); 
              if(phase->energy.total_active_energy_pulse_consuming_time>ENERGY_PULSE_CYCLE)
                phase->energy.total_active_energy_pulse_remaining_time = ENERGY_PULSE_DURATION;    
              else
                phase->energy.total_active_energy_pulse_remaining_time = phase->energy.total_active_energy_pulse_consuming_time>>1;    //set pulse to half duty
              phase->energy.total_active_energy_pulse_consuming_time = 0;
            }              
        }    
      } 
    }//if(x>0)
    //0903    negtive power
    else{
      phase->energy.total_negtive_active_power_counter -= xx;
      if(phase->energy.total_negtive_active_power_counter >= gCurrent_threshold)
      {
        phase->energy.total_negtive_active_power_counter -= gCurrent_threshold;
  
        if ((gPower_const <= 1000)&&(++phase->energy.extra_total_negtive_active_power_counter < 16)){
          ;//in extra power counter mode, and not accumulate enough power, skipped                 
        }
        else{
            phase->energy.extra_total_negtive_active_power_counter = 0;
            ++phase->energy.total_consumed_negtive_energy;
            if (phase->energy.total_consumed_negtive_energy == 0){
              phase->status |= ENERGY_LOGABLE;
              //set P energy overflow event interrupt if respond IE is set
              if(phase->int_enable & CSGNEGPEOFG)
                set_int_flag(CSGNEGPEOFG);//notify reactive energy overflow event                
            }             
        }    
      } 
    }    
    if(gCsgconf&CSGCON_PPEN_MASK){
        if (phase->energy.total_active_energy_pulse_remaining_time  &&  --phase->energy.total_active_energy_pulse_remaining_time == 0)
        {
            clr_total_energy_pulse_indicator();
        }
    }
    
    if(phase->energy.total_active_energy_pulse_consuming_time<0xffff)
      phase->energy.total_active_energy_pulse_consuming_time++;
/////////////////////////////Q pulse now///////////////////////////////////
    if((gCsgconf&CSGCON_QOFF)==0){//reactive power function not off
      if ((phase->status & CURRENT_FROM_NEUTRAL))
        xx = phase->reactive_power[1];
      else
        xx = phase->reactive_power[0];  
      //accumulate all power, no matter positive or negtive, but here we change negtive power to positive to facillate pulse generation. 
      //This will not affect the sign of power stored.
      if((gCsgconf&CSGCON_EMOD_MASK)==CSGCON_EMOD2){
        if(xx < 0)
          xx = -xx;
      }
      else{
        if((gCsgconf&CSGCON_EMOD_MASK)==CSGCON_EMOD1){//accumulate no negtive power
          if(xx < 0)
            xx = 0;
        }
        else
          xx = xx;
      }
      
      if(xx>0){   
        phase->energy.total_reactive_power_counter += xx;
        if (phase->energy.total_reactive_power_counter >= gCurrent_threshold)    
        {      
          phase->energy.total_reactive_power_counter -= gCurrent_threshold;
          if ((gPower_const < 1000)&&(++phase->energy.extra_total_reactive_power_counter < 16)){
            ;                 
          }
          else{    
              phase->energy.extra_total_reactive_power_counter = 0;
              ++phase->energy.total_consumed_reactive_energy;
                /* Ideally we want to log the energy each kWh unit, but doing
                   it with a mask here is good enough and faster. */
              if (phase->energy.total_consumed_reactive_energy == 0){       
                phase->status |= ENERGY_LOGABLE;
                //set Q energy overflow event interrupt if respond IE is set
                if(phase->int_enable & CSGQEOFG)
                  set_int_flag(CSGQEOFG);//notify reactive energy overflow event                 
              }
                /* Pulse the LED. Long pulses may not be reliable, as at full
                   power we may be pulsing many times per second. People may
                   check the meter's calibration with an instrument that counts
                   the pulsing rate, so it is important the pulses are clear,
                   distinct, and exactly at the rate of one per
                   1/ENERGY_PULSES_PER_KW_HOUR kW/h. */         
              if(gCsgconf&CSGCON_QPEN_MASK){
                set_total_reactive_energy_pulse_indicator();
                if(phase->energy.total_reactive_energy_pulse_consuming_time>ENERGY_PULSE_CYCLE)
                  phase->energy.total_reactive_energy_pulse_remaining_time = ENERGY_PULSE_DURATION;    
                else
                  phase->energy.total_reactive_energy_pulse_remaining_time = phase->energy.total_reactive_energy_pulse_consuming_time>>1;    //set pulse to half duty
                phase->energy.total_reactive_energy_pulse_consuming_time = 0;
              }                                                
          }  
        }
      }
    //0903    negtive power  
      else{
        phase->energy.total_negtive_reactive_power_counter -= xx;
        if(phase->energy.total_negtive_reactive_power_counter >= gCurrent_threshold)
        {
          phase->energy.total_negtive_reactive_power_counter -= gCurrent_threshold;
    
          if ((gPower_const <= 1000)&&(++phase->energy.extra_total_negtive_reactive_power_counter < 16)){
            ;//in extra power counter mode, and not accumulate enough power, skipped                 
          }
          else{
              phase->energy.extra_total_negtive_reactive_power_counter = 0;
              ++phase->energy.total_consumed_negtive_reactive_energy;
              if (phase->energy.total_consumed_negtive_reactive_energy == 0){
                phase->status |= ENERGY_LOGABLE;
                //set P energy overflow event interrupt if respond IE is set
                if(phase->int_enable & CSGNEGQEOFG)
                  set_int_flag(CSGNEGQEOFG);//notify active energy overflow event                
              }             
          }    
        } 
      }    
      if(gCsgconf&CSGCON_QPEN_MASK){
          if (phase->energy.total_reactive_energy_pulse_remaining_time  &&  --phase->energy.total_reactive_energy_pulse_remaining_time == 0)
          {
              clr_total_reactive_energy_pulse_indicator();
          }
      }
    }

    if(phase->energy.total_reactive_energy_pulse_consuming_time<0xffff)
      phase->energy.total_reactive_energy_pulse_consuming_time++;
    
////////////////////////////////////////////////////////////////////////////////
///////////////////////////////Pick up possible left samples ///////////////// 
    /* There may be some current samples available, which we need to pick up */
    #if defined(NEUTRAL_MONITOR_SUPPORT)
    if ((SD24CCTL_NEUTRAL & SD24IFG))
    {
        adc_buffer[2] = SD24MEM_NEUTRAL;
        SD24CCTL_NEUTRAL &= ~SD24IFG;
    }
    #endif
    if ((SD24CCTL_LIVE & SD24IFG))
    {
        adc_buffer[1] = SD24MEM_LIVE;
        SD24CCTL_LIVE &= ~SD24IFG;
    }
   
    //send out interrupt if new flag set 
    //    1׼  CSGINTPENDING ־
    //  CSGINTPENDINGλʱINTPENDINGλͬʱCSGINTPENDINGλͬʱsend_interrupt0.01
    //  INTPENDINGʱŻḴλ
    //
    if( phase->int_flag & CSGINTPENDING ){
      if(meter_status & INTPENDING)//last interrupt still not read, end it before send next interrupt
      {
//        end_interrupt();
      }
      meter_status |= INTPENDING;
      phase->int_flag &= ~CSGINTPENDING;
      char_timeout_interrupt = SAMPLES_PER_10_SECONDS/1000;     //time out is 40960/1000/4096=0.01s delay for interrupt signal low 
//      send_interrupt();  // 20110302
    }

    //update timeout for interrupt in a rate of 4kHz
    if (char_timeout_interrupt == 0);
//      end_interrupt();   // 20110302
    else  
      char_timeout_interrupt -= 1;

    //update timeout for communication in a rate of 4kHz
    // ʱж 
    if (char_timeout_1107 > 0)
      char_timeout_1107 -= 1;
    else{ // ʱ
      meter_status |= SPITIMEOUT;
      receiving = 1;              // uartʹ
      rx_msg_ptr = 0;
      meter_status &= ~WREN;
    }
    
    //clr_total_reactive_energy_pulse_indicator();    //test MIPS

#undef i 
#undef use_stage    
}


#pragma vector=TIMERA1_VECTOR
__interrupt void TIMERA1_ISR(void)
{
    static unsigned char rtc_cnt = 0;
    switch(TAIV)
    {
    case TAIV_TACCR1:
        __no_operation();
        break;
    case TAIV_TACCR2:
        __no_operation();
        break;
    case TAIV_TAIFG:                //  SMCLK 1M 8μΪ0.5s  ÿ1/16ж   RTC˸Ƶ2Hz
        rtc_cnt++;
        if((rtc_cnt & 7)==7)
        {
            if(menustatu.poweroff_fg==1)   // ⲿԴʧЧ
            {
                if((SVSCTL & SVSOP)==0)         // ⲿԴЧ
                {
                    SVSCTL &=~ SVSFG;
                    menustatu.poweroff_fg = 0;
                    menustatu.enter_lpm = 0;
                    P1DIR |= (BIT2+BIT5);  // enable backlight and pulse
                    P1SEL &=~ (BIT2+BIT5);
                    init_analog_front_end_normal();
                    SD24PRE_LIVE = set_initial_sd16_phase_correction(&phase->current[0].in_phase_correction[0], phase_nv->current[0].Phase_correction[0]);
                    __bic_SR_register_on_exit(LPM0_bits);      // ˳͹
                }
            }
            if(menustatu.enter_lpm==1)
            {
                if(menustatu.exit_lpm ==1)
                {
                    menustatu.exit_lpm = 0;
                    __bic_SR_register_on_exit(LPM0_bits);      // ˳͹
                }
            }
            FlashLCD();
        }
        if(rtc_cnt == 16)
        {
            rtc_cnt = 0;
            menustatu.rtc_bump_fg = 1;
        }
        break;
    default:
        __no_operation();
        break;
    }
}